%------------------------------------------------------------------------------
% File     : ITP143^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer PHoareTotal problem prob_402__3262836_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : PHoareTotal/prob_402__3262836_1 [Des21]

% Status   : Theorem
% Rating   : 1.00 v9.0.0, 0.67 v8.1.0, 0.75 v7.5.0
% Syntax   : Number of formulae    :  322 ( 126 unt;  58 typ;   0 def)
%            Number of atoms       :  605 ( 322 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 6716 ( 151   ~;  17   |;  59   &;6152   @)
%                                         (   0 <=>; 337  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (  10 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  266 ( 266   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   56 (  55 usr;   6 con; 0-5 aty)
%            Number of variables   : 1308 (   7   ^;1216   !;  43   ?;1308   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:18:51.683
%------------------------------------------------------------------------------
% Could-be-implicit typings (6)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_PLang_Ostate,type,
    state: $tType ).

thf(ty_t_PLang_Ocom,type,
    com: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (52)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ A ) ) ).

thf(sy_c_List_Ogen__length,type,
    gen_length: 
      !>[A: $tType] : ( nat > ( list @ A ) > nat ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olenlex,type,
    lenlex: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Olex,type,
    lex: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olistrel,type,
    listrel: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) ) ) ).

thf(sy_c_List_Olistrel1,type,
    listrel1: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ B ) ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( nat > ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Onths,type,
    nths: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ nat ) > ( list @ A ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Osubseqs,type,
    subseqs: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oexec1,type,
    pHoare1053570893_exec1: set @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oexec1p,type,
    pHoare730766435exec1p: ( list @ com ) > state > ( list @ com ) > state > $o ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oexecs,type,
    pHoare1053570959_execs: state > ( list @ com ) > state > $o ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oinf,type,
    pHoare1838713294le_inf: ( list @ com ) > state > $o ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Otermis,type,
    pHoare1335526537termis: ( list @ com ) > state > $o ).

thf(sy_c_PLang_Ocom_OCond,type,
    cond: ( state > $o ) > com > com > com ).

thf(sy_c_PLang_Ocom_ODo,type,
    do: ( state > ( set @ state ) ) > com ).

thf(sy_c_PLang_Ocom_OSemi,type,
    semi: com > com > com ).

thf(sy_c_PLang_Ocom_OWhile,type,
    while: ( state > $o ) > com > com ).

thf(sy_c_PLang_Oexec,type,
    exec: state > com > state > $o ).

thf(sy_c_PTermi_Otermi,type,
    termi: com > state > $o ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Ointernal__case__prod,type,
    produc2004651681e_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Transitive__Closure_Ontrancl,type,
    transitive_ntrancl: 
      !>[A: $tType] : ( nat > ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Wfrec_Osame__fst,type,
    same_fst: 
      !>[A: $tType,B: $tType] : ( ( A > $o ) > ( A > ( set @ ( product_prod @ B @ B ) ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a: list @ com ).

thf(sy_v_b,type,
    b: state > $o ).

thf(sy_v_ba,type,
    ba: state ).

thf(sy_v_c,type,
    c: com ).

thf(sy_v_cs,type,
    cs: list @ com ).

thf(sy_v_f,type,
    f: nat > ( product_prod @ ( list @ com ) @ state ) ).

thf(sy_v_s,type,
    s: state ).

% Relevant facts (252)
thf(fact_0_exec1E_I5_J,axiom,
    ! [B2: state > $o,C2: com,Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( ( Cs2 = Cs )
         => ( ( S2 = S )
           => ( B2 @ S ) ) )
       => ~ ( ( Cs2
              = ( cons @ com @ C2 @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) ) )
           => ( ( S2 = S )
             => ~ ( B2 @ S ) ) ) ) ) ).

% exec1E(5)
thf(fact_1_exec1_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C2: com,Cs: list @ com] :
      ( ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C2 @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.WhileTrue
thf(fact_2_exec1_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C2: com,Cs: list @ com] :
      ( ~ ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.WhileFalse
thf(fact_3_inf__def,axiom,
    ( pHoare1838713294le_inf
    = ( ^ [Cs3: list @ com,S3: state] :
        ? [F: nat > ( product_prod @ ( list @ com ) @ state )] :
          ( ( ( F @ ( zero_zero @ nat ) )
            = ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S3 ) )
          & ! [I: nat] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( F @ I ) @ ( F @ ( suc @ I ) ) ) @ pHoare1053570893_exec1 ) ) ) ) ).

% inf_def
thf(fact_4_com_Oinject_I4_J,axiom,
    ! [X41: state > $o,X42: com,Y41: state > $o,Y42: com] :
      ( ( ( while @ X41 @ X42 )
        = ( while @ Y41 @ Y42 ) )
      = ( ( X41 = Y41 )
        & ( X42 = Y42 ) ) ) ).

% com.inject(4)
thf(fact_5_nat_Oinject,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ( suc @ X2 )
        = ( suc @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% nat.inject
thf(fact_6_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_7_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_8_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B,Y1: A,Y2: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X2 )
        = ( product_Pair @ A @ B @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X2 = Y2 ) ) ) ).

% prod.inject
thf(fact_9_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
      = ( ( A2 = A3 )
        & ( B2 = B3 ) ) ) ).

% old.prod.inject
thf(fact_10_exec1__pres__termis,axiom,
    ! [Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( pHoare1335526537termis @ Cs @ S )
       => ( pHoare1335526537termis @ Cs2 @ S2 ) ) ) ).

% exec1_pres_termis
thf(fact_11_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A4: A,B4: B,C3: C] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C3 ) ) ) ).

% prod_cases3
thf(fact_12_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) )] :
      ~ ! [A4: A,B4: B,C3: C,D2: D] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D ) @ B4 @ ( product_Pair @ C @ D @ C3 @ D2 ) ) ) ) ).

% prod_cases4
thf(fact_13_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_14_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_15_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod @ A @ B] :
      ~ ! [A4: A,B4: B] :
          ( Y
         != ( product_Pair @ A @ B @ A4 @ B4 ) ) ).

% old.prod.exhaust
thf(fact_16_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
     => ~ ( ( A2 = A3 )
         => ( B2 != B3 ) ) ) ).

% Pair_inject
thf(fact_17_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P2: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ P2 ) ) ).

% prod_cases
thf(fact_18_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod @ A @ B] :
    ? [X3: A,Y3: B] :
      ( P2
      = ( product_Pair @ A @ B @ X3 @ Y3 ) ) ).

% surj_pair
thf(fact_19_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_20_n__not__Suc__n,axiom,
    ! [N: nat] :
      ( N
     != ( suc @ N ) ) ).

% n_not_Suc_n
thf(fact_21_Suc__inject,axiom,
    ! [X: nat,Y: nat] :
      ( ( ( suc @ X )
        = ( suc @ Y ) )
     => ( X = Y ) ) ).

% Suc_inject
thf(fact_22_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ? [M: nat] :
          ( N
          = ( suc @ M ) ) ) ).

% not0_implies_Suc
thf(fact_23_old_Onat_Oinducts,axiom,
    ! [P: nat > $o,Nat: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [Nat3: nat] :
            ( ( P @ Nat3 )
           => ( P @ ( suc @ Nat3 ) ) )
       => ( P @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_24_old_Onat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y
       != ( zero_zero @ nat ) )
     => ~ ! [Nat3: nat] :
            ( Y
           != ( suc @ Nat3 ) ) ) ).

% old.nat.exhaust
thf(fact_25_Zero__not__Suc,axiom,
    ! [M2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M2 ) ) ).

% Zero_not_Suc
thf(fact_26_Zero__neq__Suc,axiom,
    ! [M2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M2 ) ) ).

% Zero_neq_Suc
thf(fact_27_Suc__neq__Zero,axiom,
    ! [M2: nat] :
      ( ( suc @ M2 )
     != ( zero_zero @ nat ) ) ).

% Suc_neq_Zero
thf(fact_28_zero__induct,axiom,
    ! [P: nat > $o,K: nat] :
      ( ( P @ K )
     => ( ! [N2: nat] :
            ( ( P @ ( suc @ N2 ) )
           => ( P @ N2 ) )
       => ( P @ ( zero_zero @ nat ) ) ) ) ).

% zero_induct
thf(fact_29_diff__induct,axiom,
    ! [P: nat > nat > $o,M2: nat,N: nat] :
      ( ! [X3: nat] : ( P @ X3 @ ( zero_zero @ nat ) )
     => ( ! [Y3: nat] : ( P @ ( zero_zero @ nat ) @ ( suc @ Y3 ) )
       => ( ! [X3: nat,Y3: nat] :
              ( ( P @ X3 @ Y3 )
             => ( P @ ( suc @ X3 ) @ ( suc @ Y3 ) ) )
         => ( P @ M2 @ N ) ) ) ) ).

% diff_induct
thf(fact_30_nat__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( P @ N2 )
           => ( P @ ( suc @ N2 ) ) )
       => ( P @ N ) ) ) ).

% nat_induct
thf(fact_31_nat_OdiscI,axiom,
    ! [Nat: nat,X2: nat] :
      ( ( Nat
        = ( suc @ X2 ) )
     => ( Nat
       != ( zero_zero @ nat ) ) ) ).

% nat.discI
thf(fact_32_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_33_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat4: nat] :
      ( ( suc @ Nat4 )
     != ( zero_zero @ nat ) ) ).

% old.nat.distinct(2)
thf(fact_34_nat_Odistinct_I1_J,axiom,
    ! [X2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ X2 ) ) ).

% nat.distinct(1)
thf(fact_35_prod__induct7,axiom,
    ! [G: $tType,F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) )] :
      ( ! [A4: A,B4: B,C3: C,D2: D,E2: E,F3: F2,G2: G] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F2 @ G ) @ E2 @ ( product_Pair @ F2 @ G @ F3 @ G2 ) ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct7
thf(fact_36_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) )] :
      ( ! [A4: A,B4: B,C3: C,D2: D,E2: E,F3: F2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ F2 ) @ D2 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct6
thf(fact_37_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) )] :
      ( ! [A4: A,B4: B,C3: C,D2: D,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ E ) @ C3 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct5
thf(fact_38_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) )] :
      ( ! [A4: A,B4: B,C3: C,D2: D] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D ) @ B4 @ ( product_Pair @ C @ D @ C3 @ D2 ) ) ) )
     => ( P @ X ) ) ).

% prod_induct4
thf(fact_39_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A4: A,B4: B,C3: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C3 ) ) )
     => ( P @ X ) ) ).

% prod_induct3
thf(fact_40_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,G: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) )] :
      ~ ! [A4: A,B4: B,C3: C,D2: D,E2: E,F3: F2,G2: G] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F2 @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F2 @ G ) @ E2 @ ( product_Pair @ F2 @ G @ F3 @ G2 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_41_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) )] :
      ~ ! [A4: A,B4: B,C3: C,D2: D,E2: E,F3: F2] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ F2 ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ F2 ) @ D2 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_42_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_43_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_44_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_45_ext,axiom,
    ! [B: $tType,A: $tType,F4: A > B,G3: A > B] :
      ( ! [X3: A] :
          ( ( F4 @ X3 )
          = ( G3 @ X3 ) )
     => ( F4 = G3 ) ) ).

% ext
thf(fact_46_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) )] :
      ~ ! [A4: A,B4: B,C3: C,D2: D,E2: E] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ E ) @ C3 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_47_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B2: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
      = ( F1 @ A2 @ B2 ) ) ).

% old.prod.rec
thf(fact_48_dependent__nat__choice,axiom,
    ! [A: $tType,P: nat > A > $o,Q: nat > A > A > $o] :
      ( ? [X_1: A] : ( P @ ( zero_zero @ nat ) @ X_1 )
     => ( ! [X3: A,N2: nat] :
            ( ( P @ N2 @ X3 )
           => ? [Y4: A] :
                ( ( P @ ( suc @ N2 ) @ Y4 )
                & ( Q @ N2 @ X3 @ Y4 ) ) )
       => ? [F3: nat > A] :
          ! [N3: nat] :
            ( ( P @ N3 @ ( F3 @ N3 ) )
            & ( Q @ N3 @ ( F3 @ N3 ) @ ( F3 @ ( suc @ N3 ) ) ) ) ) ) ).

% dependent_nat_choice
thf(fact_49_exec1_OSemi,axiom,
    ! [C1: com,C22: com,Cs: list @ com,S: state] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( semi @ C1 @ C22 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C1 @ ( cons @ com @ C22 @ Cs ) ) @ S ) ) @ pHoare1053570893_exec1 ) ).

% exec1.Semi
thf(fact_50_exec1E_I3_J,axiom,
    ! [C1: com,C22: com,Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( semi @ C1 @ C22 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ~ ( ( Cs2
            = ( cons @ com @ C1 @ ( cons @ com @ C22 @ Cs ) ) )
         => ( S2 != S ) ) ) ).

% exec1E(3)
thf(fact_51_exec1_ODo,axiom,
    ! [T2: state,F4: state > ( set @ state ),S: state,Cs: list @ com] :
      ( ( member @ state @ T2 @ ( F4 @ S ) )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( do @ F4 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ T2 ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.Do
thf(fact_52_exec1E_I2_J,axiom,
    ! [F4: state > ( set @ state ),Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( do @ F4 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ~ ( ( Cs2 = Cs )
         => ~ ( member @ state @ S2 @ ( F4 @ S ) ) ) ) ).

% exec1E(2)
thf(fact_53_exec1_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs: list @ com] :
      ( ~ ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C22 @ Cs ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.IfFalse
thf(fact_54_exec1_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs: list @ com] :
      ( ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C1 @ Cs ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.IfTrue
thf(fact_55_exec1E_I4_J,axiom,
    ! [B2: state > $o,C1: com,C22: com,Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( ( Cs2
            = ( cons @ com @ C1 @ Cs ) )
         => ( ( S2 = S )
           => ~ ( B2 @ S ) ) )
       => ~ ( ( Cs2
              = ( cons @ com @ C22 @ Cs ) )
           => ( ( S2 = S )
             => ( B2 @ S ) ) ) ) ) ).

% exec1E(4)
thf(fact_56_gen__length__code_I2_J,axiom,
    ! [B: $tType,N: nat,X: B,Xs: list @ B] :
      ( ( gen_length @ B @ N @ ( cons @ B @ X @ Xs ) )
      = ( gen_length @ B @ ( suc @ N ) @ Xs ) ) ).

% gen_length_code(2)
thf(fact_57_com_Oinject_I3_J,axiom,
    ! [X31: state > $o,X32: com,X33: com,Y31: state > $o,Y32: com,Y33: com] :
      ( ( ( cond @ X31 @ X32 @ X33 )
        = ( cond @ Y31 @ Y32 @ Y33 ) )
      = ( ( X31 = Y31 )
        & ( X32 = Y32 )
        & ( X33 = Y33 ) ) ) ).

% com.inject(3)
thf(fact_58_com_Oinject_I1_J,axiom,
    ! [X1: state > ( set @ state ),Y1: state > ( set @ state )] :
      ( ( ( do @ X1 )
        = ( do @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% com.inject(1)
thf(fact_59_com_Oinject_I2_J,axiom,
    ! [X21: com,X22: com,Y21: com,Y22: com] :
      ( ( ( semi @ X21 @ X22 )
        = ( semi @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% com.inject(2)
thf(fact_60_com_Odistinct_I11_J,axiom,
    ! [X21: com,X22: com,X31: state > $o,X32: com,X33: com] :
      ( ( semi @ X21 @ X22 )
     != ( cond @ X31 @ X32 @ X33 ) ) ).

% com.distinct(11)
thf(fact_61_com_Odistinct_I3_J,axiom,
    ! [X1: state > ( set @ state ),X31: state > $o,X32: com,X33: com] :
      ( ( do @ X1 )
     != ( cond @ X31 @ X32 @ X33 ) ) ).

% com.distinct(3)
thf(fact_62_com_Odistinct_I1_J,axiom,
    ! [X1: state > ( set @ state ),X21: com,X22: com] :
      ( ( do @ X1 )
     != ( semi @ X21 @ X22 ) ) ).

% com.distinct(1)
thf(fact_63_com_Odistinct_I19_J,axiom,
    ! [X31: state > $o,X32: com,X33: com,X41: state > $o,X42: com] :
      ( ( cond @ X31 @ X32 @ X33 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(19)
thf(fact_64_com_Odistinct_I5_J,axiom,
    ! [X1: state > ( set @ state ),X41: state > $o,X42: com] :
      ( ( do @ X1 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(5)
thf(fact_65_com_Odistinct_I13_J,axiom,
    ! [X21: com,X22: com,X41: state > $o,X42: com] :
      ( ( semi @ X21 @ X22 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(13)
thf(fact_66_execs__pres__termis,axiom,
    ! [Cs: list @ com,S: state,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( ( pHoare1335526537termis @ Cs @ S )
       => ( pHoare1335526537termis @ Cs2 @ S2 ) ) ) ).

% execs_pres_termis
thf(fact_67_internal__case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,C2: B > C > A,A2: B,B2: C] :
      ( ( produc2004651681e_prod @ B @ C @ A @ C2 @ ( product_Pair @ B @ C @ A2 @ B2 ) )
      = ( C2 @ A2 @ B2 ) ) ).

% internal_case_prod_conv
thf(fact_68_exec1p_OSemi,axiom,
    ! [C1: com,C22: com,Cs: list @ com,S: state] : ( pHoare730766435exec1p @ ( cons @ com @ ( semi @ C1 @ C22 ) @ Cs ) @ S @ ( cons @ com @ C1 @ ( cons @ com @ C22 @ Cs ) ) @ S ) ).

% exec1p.Semi
thf(fact_69_exec1p_ODo,axiom,
    ! [T2: state,F4: state > ( set @ state ),S: state,Cs: list @ com] :
      ( ( member @ state @ T2 @ ( F4 @ S ) )
     => ( pHoare730766435exec1p @ ( cons @ com @ ( do @ F4 ) @ Cs ) @ S @ Cs @ T2 ) ) ).

% exec1p.Do
thf(fact_70_exec1p_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs: list @ com] :
      ( ( B2 @ S )
     => ( pHoare730766435exec1p @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs ) @ S @ ( cons @ com @ C1 @ Cs ) @ S ) ) ).

% exec1p.IfTrue
thf(fact_71_exec1p_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs: list @ com] :
      ( ~ ( B2 @ S )
     => ( pHoare730766435exec1p @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs ) @ S @ ( cons @ com @ C22 @ Cs ) @ S ) ) ).

% exec1p.IfFalse
thf(fact_72_exec1p_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C2: com,Cs: list @ com] :
      ( ( B2 @ S )
     => ( pHoare730766435exec1p @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) @ S @ ( cons @ com @ C2 @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) ) @ S ) ) ).

% exec1p.WhileTrue
thf(fact_73_renumber__aux,axiom,
    ! [A: $tType,A2: A,F4: nat > A,R: set @ ( product_prod @ A @ A ),B2: A] :
      ( ! [I2: nat] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ ( F4 @ I2 ) ) @ ( transitive_rtrancl @ A @ R ) )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F4 @ I2 ) @ ( F4 @ ( suc @ I2 ) ) ) @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
       => ( ( B2
            = ( F4 @ ( zero_zero @ nat ) ) )
         => ? [F3: nat > A] :
              ( ( ( F3 @ ( zero_zero @ nat ) )
                = A2 )
              & ! [I3: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F3 @ I3 ) @ ( F3 @ ( suc @ I3 ) ) ) @ R ) ) ) ) ) ).

% renumber_aux
thf(fact_74_renumber,axiom,
    ! [A: $tType,A2: A,F4: nat > A,R: set @ ( product_prod @ A @ A )] :
      ( ! [I2: nat] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ ( F4 @ I2 ) ) @ ( transitive_rtrancl @ A @ R ) )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F4 @ I2 ) @ ( F4 @ ( suc @ I2 ) ) ) @ R ) )
     => ? [F3: nat > A] :
          ( ( ( F3 @ ( zero_zero @ nat ) )
            = A2 )
          & ! [I3: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F3 @ I3 ) @ ( F3 @ ( suc @ I3 ) ) ) @ R ) ) ) ).

% renumber
thf(fact_75_exec1p_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C2: com,Cs: list @ com] :
      ( ~ ( B2 @ S )
     => ( pHoare730766435exec1p @ ( cons @ com @ ( while @ B2 @ C2 ) @ Cs ) @ S @ Cs @ S ) ) ).

% exec1p.WhileFalse
thf(fact_76_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Ax: A,Ay: B,Bx: A,By: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ),P: A > B > $o] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( P @ Bx @ By )
       => ( ! [A4: A,B4: B,Aa: A,Ba: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B4 ) @ ( product_Pair @ A @ B @ Aa @ Ba ) ) @ R )
             => ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Aa @ Ba ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
               => ( ( P @ Aa @ Ba )
                 => ( P @ A4 @ B4 ) ) ) )
         => ( P @ Ax @ Ay ) ) ) ) ).

% converse_rtrancl_induct2
thf(fact_77_converse__rtranclE2,axiom,
    ! [B: $tType,A: $tType,Xa: A,Xb: B,Za: A,Zb: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) )] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Xa @ Xb ) @ ( product_Pair @ A @ B @ Za @ Zb ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( ( product_Pair @ A @ B @ Xa @ Xb )
         != ( product_Pair @ A @ B @ Za @ Zb ) )
       => ~ ! [A4: A,B4: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Xa @ Xb ) @ ( product_Pair @ A @ B @ A4 @ B4 ) ) @ R )
             => ~ ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B4 ) @ ( product_Pair @ A @ B @ Za @ Zb ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) ) ) ) ) ).

% converse_rtranclE2
thf(fact_78_rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Ax: A,Ay: B,Bx: A,By: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ),P: A > B > $o] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( P @ Ax @ Ay )
       => ( ! [A4: A,B4: B,Aa: A,Ba: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ A4 @ B4 ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
             => ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B4 ) @ ( product_Pair @ A @ B @ Aa @ Ba ) ) @ R )
               => ( ( P @ A4 @ B4 )
                 => ( P @ Aa @ Ba ) ) ) )
         => ( P @ Bx @ By ) ) ) ) ).

% rtrancl_induct2
thf(fact_79_rtrancl__idemp,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( transitive_rtrancl @ A @ ( transitive_rtrancl @ A @ R ) )
      = ( transitive_rtrancl @ A @ R ) ) ).

% rtrancl_idemp
thf(fact_80_r__into__rtrancl,axiom,
    ! [A: $tType,P2: product_prod @ A @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ P2 @ R )
     => ( member @ ( product_prod @ A @ A ) @ P2 @ ( transitive_rtrancl @ A @ R ) ) ) ).

% r_into_rtrancl
thf(fact_81_exec__impl__execs,axiom,
    ! [S: state,C2: com,S2: state,Cs: list @ com] :
      ( ( exec @ S @ C2 @ S2 )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C2 @ Cs ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ) ) ).

% exec_impl_execs
thf(fact_82_exec_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C2: com,T2: state,U: state] :
      ( ( B2 @ S )
     => ( ( exec @ S @ C2 @ T2 )
       => ( ( exec @ T2 @ ( while @ B2 @ C2 ) @ U )
         => ( exec @ S @ ( while @ B2 @ C2 ) @ U ) ) ) ) ).

% exec.WhileTrue
thf(fact_83_exec_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C2: com] :
      ( ~ ( B2 @ S )
     => ( exec @ S @ ( while @ B2 @ C2 ) @ S ) ) ).

% exec.WhileFalse
thf(fact_84_exec_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,T2: state,C22: com] :
      ( ( B2 @ S )
     => ( ( exec @ S @ C1 @ T2 )
       => ( exec @ S @ ( cond @ B2 @ C1 @ C22 ) @ T2 ) ) ) ).

% exec.IfTrue
thf(fact_85_exec_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C22: com,T2: state,C1: com] :
      ( ~ ( B2 @ S )
     => ( ( exec @ S @ C22 @ T2 )
       => ( exec @ S @ ( cond @ B2 @ C1 @ C22 ) @ T2 ) ) ) ).

% exec.IfFalse
thf(fact_86_exec_ODo,axiom,
    ! [T2: state,F4: state > ( set @ state ),S: state] :
      ( ( member @ state @ T2 @ ( F4 @ S ) )
     => ( exec @ S @ ( do @ F4 ) @ T2 ) ) ).

% exec.Do
thf(fact_87_exec_OSemi,axiom,
    ! [S0: state,C1: com,S1: state,C22: com,S22: state] :
      ( ( exec @ S0 @ C1 @ S1 )
     => ( ( exec @ S1 @ C22 @ S22 )
       => ( exec @ S0 @ ( semi @ C1 @ C22 ) @ S22 ) ) ) ).

% exec.Semi
thf(fact_88_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C2 ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% converse_rtrancl_into_rtrancl
thf(fact_89_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C2 ) @ R )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% rtrancl.rtrancl_into_rtrancl
thf(fact_90_converse__rtrancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( P @ B2 )
       => ( ! [Y3: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z ) @ R )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
               => ( ( P @ Z )
                 => ( P @ Y3 ) ) ) )
         => ( P @ A2 ) ) ) ) ).

% converse_rtrancl_induct
thf(fact_91_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,A2: A,R: set @ ( product_prod @ A @ A )] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ ( transitive_rtrancl @ A @ R ) ) ).

% rtrancl.rtrancl_refl
thf(fact_92_converse__rtranclE,axiom,
    ! [A: $tType,X: A,Z2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( X != Z2 )
       => ~ ! [Y3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y3 ) @ R )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ) ).

% converse_rtranclE
thf(fact_93_rtrancl_Oinducts,axiom,
    ! [A: $tType,X1: A,X2: A,R: set @ ( product_prod @ A @ A ),P: A > A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X1 @ X2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ! [A4: A] : ( P @ A4 @ A4 )
       => ( ! [A4: A,B4: A,C3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B4 ) @ ( transitive_rtrancl @ A @ R ) )
             => ( ( P @ A4 @ B4 )
               => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B4 @ C3 ) @ R )
                 => ( P @ A4 @ C3 ) ) ) )
         => ( P @ X1 @ X2 ) ) ) ) ).

% rtrancl.inducts
thf(fact_94_rtrancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( P @ A2 )
       => ( ! [Y3: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y3 ) @ ( transitive_rtrancl @ A @ R ) )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z ) @ R )
               => ( ( P @ Y3 )
                 => ( P @ Z ) ) ) )
         => ( P @ B2 ) ) ) ) ).

% rtrancl_induct
thf(fact_95_rtrancl__trans,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Z2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y @ Z2 ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% rtrancl_trans
thf(fact_96_rtrancl_Osimps,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_rtrancl @ A @ R ) )
      = ( ? [A6: A] :
            ( ( A1 = A6 )
            & ( A22 = A6 ) )
        | ? [A6: A,B5: A,C4: A] :
            ( ( A1 = A6 )
            & ( A22 = C4 )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A6 @ B5 ) @ ( transitive_rtrancl @ A @ R ) )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B5 @ C4 ) @ R ) ) ) ) ).

% rtrancl.simps
thf(fact_97_rtrancl_Ocases,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( A22 != A1 )
       => ~ ! [B4: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ B4 ) @ ( transitive_rtrancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B4 @ A22 ) @ R ) ) ) ) ).

% rtrancl.cases
thf(fact_98_rtranclE,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( A2 != B2 )
       => ~ ! [Y3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y3 ) @ ( transitive_rtrancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ B2 ) @ R ) ) ) ) ).

% rtranclE
thf(fact_99_exec1s__impl__exec,axiom,
    ! [C2: com,S: state,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C2 @ ( nil @ com ) ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ T2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( exec @ S @ C2 @ T2 ) ) ).

% exec1s_impl_exec
thf(fact_100_app__execs,axiom,
    ! [Cs: list @ com,S: state,Cs2: list @ com,S2: state,Cs22: list @ com] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs @ Cs22 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs2 @ Cs22 ) @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ) ) ).

% app_execs
thf(fact_101_termis_Osimps_I2_J,axiom,
    ! [C2: com,Cs: list @ com,S: state] :
      ( ( pHoare1335526537termis @ ( cons @ com @ C2 @ Cs ) @ S )
      = ( ( termi @ C2 @ S )
        & ! [T3: state] :
            ( ( exec @ S @ C2 @ T3 )
           => ( pHoare1335526537termis @ Cs @ T3 ) ) ) ) ).

% termis.simps(2)
thf(fact_102_execs_Ointros_I2_J,axiom,
    ! [S: state,C2: com,T2: state,Cs: list @ com,U: state] :
      ( ( exec @ S @ C2 @ T2 )
     => ( ( pHoare1053570959_execs @ T2 @ Cs @ U )
       => ( pHoare1053570959_execs @ S @ ( cons @ com @ C2 @ Cs ) @ U ) ) ) ).

% execs.intros(2)
thf(fact_103_same__fstI,axiom,
    ! [B: $tType,A: $tType,P: A > $o,X: A,Y5: B,Y: B,R2: A > ( set @ ( product_prod @ B @ B ) )] :
      ( ( P @ X )
     => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y5 @ Y ) @ ( R2 @ X ) )
       => ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ ( product_Pair @ A @ B @ X @ Y ) ) @ ( same_fst @ A @ B @ P @ R2 ) ) ) ) ).

% same_fstI
thf(fact_104_ntrancl__Zero,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ( transitive_ntrancl @ A @ ( zero_zero @ nat ) @ R2 )
      = R2 ) ).

% ntrancl_Zero
thf(fact_105_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Xs @ Zs ) )
      = ( Ys = Zs ) ) ).

% same_append_eq
thf(fact_106_append__same__eq,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Ys @ Xs )
        = ( append @ A @ Zs @ Xs ) )
      = ( Ys = Zs ) ) ).

% append_same_eq
thf(fact_107_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys ) @ Zs )
      = ( append @ A @ Xs @ ( append @ A @ Ys @ Zs ) ) ) ).

% append_assoc
thf(fact_108_append_Oassoc,axiom,
    ! [A: $tType,A2: list @ A,B2: list @ A,C2: list @ A] :
      ( ( append @ A @ ( append @ A @ A2 @ B2 ) @ C2 )
      = ( append @ A @ A2 @ ( append @ A @ B2 @ C2 ) ) ) ).

% append.assoc
thf(fact_109_append_Oright__neutral,axiom,
    ! [A: $tType,A2: list @ A] :
      ( ( append @ A @ A2 @ ( nil @ A ) )
      = A2 ) ).

% append.right_neutral
thf(fact_110_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_111_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_112_self__append__conv2,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
        = ( append @ A @ Xs @ Ys ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_113_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Ys )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_114_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys ) )
      = ( Ys
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_115_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Xs )
      = ( Ys
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_116_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_117_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = ( append @ A @ Ys @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

% append1_eq_conv
thf(fact_118_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_119_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( Zs
            = ( cons @ A @ X @ Xs ) ) )
        | ? [Ys2: list @ A] :
            ( ( Ys
              = ( cons @ A @ X @ Ys2 ) )
            & ( ( append @ A @ Ys2 @ Zs )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_120_Cons__eq__append__conv,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( ( cons @ A @ X @ Xs )
            = Zs ) )
        | ? [Ys2: list @ A] :
            ( ( ( cons @ A @ X @ Ys2 )
              = Ys )
            & ( Xs
              = ( append @ A @ Ys2 @ Zs ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_121_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys3: list @ A,Y3: A] :
            ( Xs
           != ( append @ A @ Ys3 @ ( cons @ A @ Y3 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_122_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_123_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X3: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_124_execs_Ointros_I1_J,axiom,
    ! [S: state] : ( pHoare1053570959_execs @ S @ ( nil @ com ) @ S ) ).

% execs.intros(1)
thf(fact_125_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Zs @ Ts ) )
      = ( ? [Us: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs @ Us ) )
              & ( ( append @ A @ Us @ Ys )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us )
                = Zs )
              & ( Ys
                = ( append @ A @ Us @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_126_append_Oleft__neutral,axiom,
    ! [A: $tType,A2: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ A2 )
      = A2 ) ).

% append.left_neutral
thf(fact_127_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs: list @ A,Ys: list @ A,Us2: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs )
     => ( ( Ys
          = ( append @ A @ Xs1 @ Us2 ) )
       => ( ( append @ A @ Xs @ Ys )
          = ( append @ A @ Zs @ Us2 ) ) ) ) ).

% append_eq_appendI
thf(fact_128_append__Nil,axiom,
    ! [A: $tType,Ys: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys )
      = Ys ) ).

% append_Nil
thf(fact_129_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs = Ys )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys ) ) ) ).

% eq_Nil_appendI
thf(fact_130_append__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A] :
      ( ( append @ A @ ( cons @ A @ X @ Xs ) @ Ys )
      = ( cons @ A @ X @ ( append @ A @ Xs @ Ys ) ) ) ).

% append_Cons
thf(fact_131_Cons__eq__appendI,axiom,
    ! [A: $tType,X: A,Xs1: list @ A,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs1 )
        = Ys )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs ) )
       => ( ( cons @ A @ X @ Xs )
          = ( append @ A @ Ys @ Zs ) ) ) ) ).

% Cons_eq_appendI
thf(fact_132_splice_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( list @ A ) @ ( list @ A )] :
      ( ! [Ys3: list @ A] :
          ( X
         != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ys3 ) )
     => ~ ! [X3: A,Xs2: list @ A,Ys3: list @ A] :
            ( X
           != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 ) ) ) ).

% splice.cases
thf(fact_133_shuffles_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( list @ A ) @ ( list @ A )] :
      ( ! [Ys3: list @ A] :
          ( X
         != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ys3 ) )
     => ( ! [Xs2: list @ A] :
            ( X
           != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs2 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Xs2: list @ A,Y3: A,Ys3: list @ A] :
              ( X
             != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) ) ) ).

% shuffles.cases
thf(fact_134_sorted__wrt_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( A > A > $o ) @ ( list @ A )] :
      ( ! [P3: A > A > $o] :
          ( X
         != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( nil @ A ) ) )
     => ~ ! [P3: A > A > $o,X3: A,Ys3: list @ A] :
            ( X
           != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ Ys3 ) ) ) ) ).

% sorted_wrt.cases
thf(fact_135_arg__min__list_Ocases,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [X: product_prod @ ( A > B ) @ ( list @ A )] :
          ( ! [F3: A > B,X3: A] :
              ( X
             != ( product_Pair @ ( A > B ) @ ( list @ A ) @ F3 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
         => ( ! [F3: A > B,X3: A,Y3: A,Zs2: list @ A] :
                ( X
               != ( product_Pair @ ( A > B ) @ ( list @ A ) @ F3 @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Zs2 ) ) ) )
           => ~ ! [A4: A > B] :
                  ( X
                 != ( product_Pair @ ( A > B ) @ ( list @ A ) @ A4 @ ( nil @ A ) ) ) ) ) ) ).

% arg_min_list.cases
thf(fact_136_successively_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( A > A > $o ) @ ( list @ A )] :
      ( ! [P3: A > A > $o] :
          ( X
         != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( nil @ A ) ) )
     => ( ! [P3: A > A > $o,X3: A] :
            ( X
           != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
       => ~ ! [P3: A > A > $o,X3: A,Y3: A,Xs2: list @ A] :
              ( X
             != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) ) ) ).

% successively.cases
thf(fact_137_map__tailrec__rev_Ocases,axiom,
    ! [A: $tType,B: $tType,X: product_prod @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) )] :
      ( ! [F3: A > B,Bs: list @ B] :
          ( X
         != ( product_Pair @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ F3 @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ Bs ) ) )
     => ~ ! [F3: A > B,A4: A,As: list @ A,Bs: list @ B] :
            ( X
           != ( product_Pair @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ F3 @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ A4 @ As ) @ Bs ) ) ) ) ).

% map_tailrec_rev.cases
thf(fact_138_strict__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ( P @ ( nil @ A ) )
         => ( ! [X3: A,Ys3: list @ A] :
                ( ( P @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Ys3 ) ) )
           => ( P @ A0 ) ) ) ) ).

% strict_sorted.induct
thf(fact_139_strict__sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X3: A,Ys3: list @ A] :
                ( X
               != ( cons @ A @ X3 @ Ys3 ) ) ) ) ).

% strict_sorted.cases
thf(fact_140_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F3: A > B,X_12: list @ B] : ( P @ F3 @ ( nil @ A ) @ X_12 )
     => ( ! [F3: A > B,A4: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F3 @ As @ ( cons @ B @ ( F3 @ A4 ) @ Bs ) )
           => ( P @ F3 @ ( cons @ A @ A4 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_141_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_142_successively_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X3: A] : ( P @ P3 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [P3: A > A > $o,X3: A,Y3: A,Xs2: list @ A] :
              ( ( P @ P3 @ ( cons @ A @ Y3 @ Xs2 ) )
             => ( P @ P3 @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% successively.induct
thf(fact_143_arg__min__list_Oinduct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [P: ( A > B ) > ( list @ A ) > $o,A0: A > B,A1: list @ A] :
          ( ! [F3: A > B,X3: A] : ( P @ F3 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
         => ( ! [F3: A > B,X3: A,Y3: A,Zs2: list @ A] :
                ( ( P @ F3 @ ( cons @ A @ Y3 @ Zs2 ) )
               => ( P @ F3 @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Zs2 ) ) ) )
           => ( ! [A4: A > B] : ( P @ A4 @ ( nil @ A ) )
             => ( P @ A0 @ A1 ) ) ) ) ) ).

% arg_min_list.induct
thf(fact_144_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y3: A,Xs2: list @ A] :
              ( ( ( X3 = Y3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
             => ( ( ( X3 != Y3 )
                 => ( P @ ( cons @ A @ Y3 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_145_sorted__wrt_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X3: A,Ys3: list @ A] :
            ( ( P @ P3 @ Ys3 )
           => ( P @ P3 @ ( cons @ A @ X3 @ Ys3 ) ) )
       => ( P @ A0 @ A1 ) ) ) ).

% sorted_wrt.induct
thf(fact_146_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y3: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_147_shuffles_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_12: list @ A] : ( P @ ( nil @ A ) @ X_12 )
     => ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ A ) )
       => ( ! [X3: A,Xs2: list @ A,Y3: A,Ys3: list @ A] :
              ( ( P @ Xs2 @ ( cons @ A @ Y3 @ Ys3 ) )
             => ( ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% shuffles.induct
thf(fact_148_min__list_Oinduct,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ! [X3: A,Xs2: list @ A] :
              ( ! [X212: A,X222: list @ A] :
                  ( ( Xs2
                    = ( cons @ A @ X212 @ X222 ) )
                 => ( P @ Xs2 ) )
             => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
         => ( ( P @ ( nil @ A ) )
           => ( P @ A0 ) ) ) ) ).

% min_list.induct
thf(fact_149_min__list_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X: list @ A] :
          ( ! [X3: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ Xs2 ) )
         => ( X
            = ( nil @ A ) ) ) ) ).

% min_list.cases
thf(fact_150_induct__list012,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y3: A,Zs2: list @ A] :
              ( ( P @ Zs2 )
             => ( ( P @ ( cons @ A @ Y3 @ Zs2 ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Zs2 ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% induct_list012
thf(fact_151_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_12: list @ A] : ( P @ ( nil @ A ) @ X_12 )
     => ( ! [X3: A,Xs2: list @ A,Ys3: list @ A] :
            ( ( P @ Ys3 @ Xs2 )
           => ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% splice.induct
thf(fact_152_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y3: B,Ys3: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y3 @ Ys3 ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys3: list @ B] :
                ( ( P @ Xs2 @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y3 @ Ys3 ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_153_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y6: A,Ys4: list @ A] :
            ( Xs
            = ( cons @ A @ Y6 @ Ys4 ) ) ) ) ).

% neq_Nil_conv
thf(fact_154_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X12: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X12 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_155_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X213: A,X223: list @ A] :
            ( Y
           != ( cons @ A @ X213 @ X223 ) ) ) ).

% list.exhaust
thf(fact_156_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_157_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_158_execs_Ocases,axiom,
    ! [A1: state,A22: list @ com,A32: state] :
      ( ( pHoare1053570959_execs @ A1 @ A22 @ A32 )
     => ( ( ( A22
            = ( nil @ com ) )
         => ( A32 != A1 ) )
       => ~ ! [C3: com,T4: state,Cs4: list @ com] :
              ( ( A22
                = ( cons @ com @ C3 @ Cs4 ) )
             => ( ( exec @ A1 @ C3 @ T4 )
               => ~ ( pHoare1053570959_execs @ T4 @ Cs4 @ A32 ) ) ) ) ) ).

% execs.cases
thf(fact_159_execs_Osimps,axiom,
    ( pHoare1053570959_execs
    = ( ^ [A12: state,A23: list @ com,A33: state] :
          ( ? [S3: state] :
              ( ( A12 = S3 )
              & ( A23
                = ( nil @ com ) )
              & ( A33 = S3 ) )
          | ? [S3: state,C4: com,T3: state,Cs3: list @ com,U2: state] :
              ( ( A12 = S3 )
              & ( A23
                = ( cons @ com @ C4 @ Cs3 ) )
              & ( A33 = U2 )
              & ( exec @ S3 @ C4 @ T3 )
              & ( pHoare1053570959_execs @ T3 @ Cs3 @ U2 ) ) ) ) ) ).

% execs.simps
thf(fact_160_execs_Oinducts,axiom,
    ! [X1: state,X2: list @ com,X34: state,P: state > ( list @ com ) > state > $o] :
      ( ( pHoare1053570959_execs @ X1 @ X2 @ X34 )
     => ( ! [S4: state] : ( P @ S4 @ ( nil @ com ) @ S4 )
       => ( ! [S4: state,C3: com,T4: state,Cs4: list @ com,U3: state] :
              ( ( exec @ S4 @ C3 @ T4 )
             => ( ( pHoare1053570959_execs @ T4 @ Cs4 @ U3 )
               => ( ( P @ T4 @ Cs4 @ U3 )
                 => ( P @ S4 @ ( cons @ com @ C3 @ Cs4 ) @ U3 ) ) ) )
         => ( P @ X1 @ X2 @ X34 ) ) ) ) ).

% execs.inducts
thf(fact_161_while__termiE,axiom,
    ! [B2: state > $o,C2: com,S: state] :
      ( ( termi @ ( while @ B2 @ C2 ) @ S )
     => ( ( B2 @ S )
       => ( termi @ C2 @ S ) ) ) ).

% while_termiE
thf(fact_162_termis_Osimps_I1_J,axiom,
    ! [S: state] : ( pHoare1335526537termis @ ( nil @ com ) @ S ) ).

% termis.simps(1)
thf(fact_163_gen__length__code_I1_J,axiom,
    ! [A: $tType,N: nat] :
      ( ( gen_length @ A @ N @ ( nil @ A ) )
      = N ) ).

% gen_length_code(1)
thf(fact_164_while__termiE2,axiom,
    ! [B2: state > $o,C2: com,S: state,T2: state] :
      ( ( termi @ ( while @ B2 @ C2 ) @ S )
     => ( ( B2 @ S )
       => ( ( exec @ S @ C2 @ T2 )
         => ( termi @ ( while @ B2 @ C2 ) @ T2 ) ) ) ) ).

% while_termiE2
thf(fact_165_exec1s__impl__execs,axiom,
    ! [Cs: list @ com,S: state,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ T2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( pHoare1053570959_execs @ S @ Cs @ T2 ) ) ).

% exec1s_impl_execs
thf(fact_166_execs__pres__termi,axiom,
    ! [C2: com,S: state,C5: com,Cs2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C2 @ ( nil @ com ) ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C5 @ Cs2 ) @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( ( termi @ C2 @ S )
       => ( termi @ C5 @ S2 ) ) ) ).

% execs_pres_termi
thf(fact_167_app__exec,axiom,
    ! [Cs: list @ com,S: state,Cs2: list @ com,S2: state,Cs22: list @ com] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs @ Cs22 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs2 @ Cs22 ) @ S2 ) ) @ pHoare1053570893_exec1 ) ) ).

% app_exec
thf(fact_168_exec1E_I1_J,axiom,
    ! [S: state,Cs2: list @ com,S2: state] :
      ~ ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S2 ) ) @ pHoare1053570893_exec1 ) ).

% exec1E(1)
thf(fact_169_termi__while,axiom,
    ! [B2: state > $o,C2: com,F4: nat > state,K: nat] :
      ( ( termi @ ( while @ B2 @ C2 ) @ ( F4 @ K ) )
     => ( ! [I2: nat] : ( exec @ ( F4 @ I2 ) @ C2 @ ( F4 @ ( suc @ I2 ) ) )
       => ? [I2: nat] :
            ~ ( B2 @ ( F4 @ I2 ) ) ) ) ).

% termi_while
thf(fact_170_termi__while__lemma,axiom,
    ! [W: com,Fk: state,F4: nat > state,K: nat,B2: state > $o,C2: com] :
      ( ( termi @ W @ Fk )
     => ( ( ( Fk
            = ( F4 @ K ) )
          & ( W
            = ( while @ B2 @ C2 ) )
          & ! [I2: nat] : ( exec @ ( F4 @ I2 ) @ C2 @ ( F4 @ ( suc @ I2 ) ) ) )
       => ? [I2: nat] :
            ~ ( B2 @ ( F4 @ I2 ) ) ) ) ).

% termi_while_lemma
thf(fact_171_termi_OSemi,axiom,
    ! [C1: com,S0: state,C22: com] :
      ( ( termi @ C1 @ S0 )
     => ( ! [S12: state] :
            ( ( exec @ S0 @ C1 @ S12 )
           => ( termi @ C22 @ S12 ) )
       => ( termi @ ( semi @ C1 @ C22 ) @ S0 ) ) ) ).

% termi.Semi
thf(fact_172_termi_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C2: com] :
      ( ( B2 @ S )
     => ( ( termi @ C2 @ S )
       => ( ! [T4: state] :
              ( ( exec @ S @ C2 @ T4 )
             => ( termi @ ( while @ B2 @ C2 ) @ T4 ) )
         => ( termi @ ( while @ B2 @ C2 ) @ S ) ) ) ) ).

% termi.WhileTrue
thf(fact_173_termi_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C22: com,C1: com] :
      ( ~ ( B2 @ S )
     => ( ( termi @ C22 @ S )
       => ( termi @ ( cond @ B2 @ C1 @ C22 ) @ S ) ) ) ).

% termi.IfFalse
thf(fact_174_termi_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C2: com] :
      ( ~ ( B2 @ S )
     => ( termi @ ( while @ B2 @ C2 ) @ S ) ) ).

% termi.WhileFalse
thf(fact_175_termi_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com] :
      ( ( B2 @ S )
     => ( ( termi @ C1 @ S )
       => ( termi @ ( cond @ B2 @ C1 @ C22 ) @ S ) ) ) ).

% termi.IfTrue
thf(fact_176_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N
          = ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N @ ( nil @ A ) )
          = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) )
      & ( ( N
         != ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N @ ( nil @ A ) )
          = ( nil @ ( list @ A ) ) ) ) ) ).

% n_lists_Nil
thf(fact_177_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( n_lists @ A @ ( zero_zero @ nat ) @ Xs )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% n_lists.simps(1)
thf(fact_178_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_179_bind__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X: B,Xs: list @ B,F4: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( cons @ B @ X @ Xs ) @ F4 )
      = ( append @ A @ ( F4 @ X ) @ ( bind @ B @ A @ Xs @ F4 ) ) ) ).

% bind_simps(2)
thf(fact_180_subseqs_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( subseqs @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% subseqs.simps(1)
thf(fact_181_snoc__listrel1__snoc__iff,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A,Y: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) @ ( append @ A @ Ys @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) @ ( listrel1 @ A @ R ) )
      = ( ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
          & ( X = Y ) )
        | ( ( Xs = Ys )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R ) ) ) ) ).

% snoc_listrel1_snoc_iff
thf(fact_182_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F4: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F4 )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_183_Cons__listrel1__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Y: A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Ys ) ) @ ( listrel1 @ A @ R ) )
      = ( ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
          & ( Xs = Ys ) )
        | ( ( X = Y )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1_Cons
thf(fact_184_rtrancl__listrel1__ConsI1,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A ),X: A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ X @ Ys ) ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ).

% rtrancl_listrel1_ConsI1
thf(fact_185_listrel1I2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A ),X: A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ X @ Ys ) ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel1I2
thf(fact_186_not__Nil__listrel1,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Xs ) @ ( listrel1 @ A @ R ) ) ).

% not_Nil_listrel1
thf(fact_187_not__listrel1__Nil,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ ( nil @ A ) ) @ ( listrel1 @ A @ R ) ) ).

% not_listrel1_Nil
thf(fact_188_append__listrel1I,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A ),Us2: list @ A,Vs: list @ A] :
      ( ( ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
          & ( Us2 = Vs ) )
        | ( ( Xs = Ys )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Us2 @ Vs ) @ ( listrel1 @ A @ R ) ) ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Us2 ) @ ( append @ A @ Ys @ Vs ) ) @ ( listrel1 @ A @ R ) ) ) ).

% append_listrel1I
thf(fact_189_listrel1I1,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Xs ) ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel1I1
thf(fact_190_Cons__listrel1E1,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ Ys ) @ ( listrel1 @ A @ R ) )
     => ( ! [Y3: A] :
            ( ( Ys
              = ( cons @ A @ Y3 @ Xs ) )
           => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y3 ) @ R ) )
       => ~ ! [Zs2: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Zs2 ) )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Zs2 ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1E1
thf(fact_191_Cons__listrel1E2,axiom,
    ! [A: $tType,Xs: list @ A,Y: A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ ( cons @ A @ Y @ Ys ) ) @ ( listrel1 @ A @ R ) )
     => ( ! [X3: A] :
            ( ( Xs
              = ( cons @ A @ X3 @ Ys ) )
           => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y ) @ R ) )
       => ~ ! [Zs2: list @ A] :
              ( ( Xs
                = ( cons @ A @ Y @ Zs2 ) )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Zs2 @ Ys ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1E2
thf(fact_192_listrel1I,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Us2: list @ A,Vs: list @ A,Ys: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
     => ( ( Xs
          = ( append @ A @ Us2 @ ( cons @ A @ X @ Vs ) ) )
       => ( ( Ys
            = ( append @ A @ Us2 @ ( cons @ A @ Y @ Vs ) ) )
         => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% listrel1I
thf(fact_193_listrel1E,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
     => ~ ! [X3: A,Y3: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y3 ) @ R )
           => ! [Us3: list @ A,Vs2: list @ A] :
                ( ( Xs
                  = ( append @ A @ Us3 @ ( cons @ A @ X3 @ Vs2 ) ) )
               => ( Ys
                 != ( append @ A @ Us3 @ ( cons @ A @ Y3 @ Vs2 ) ) ) ) ) ) ).

% listrel1E
thf(fact_194_rtrancl__listrel1__ConsI2,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Ys ) ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% rtrancl_listrel1_ConsI2
thf(fact_195_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,F4: B > ( list @ A ),X: B,Xs: list @ B] :
      ( ( maps @ B @ A @ F4 @ ( cons @ B @ X @ Xs ) )
      = ( append @ A @ ( F4 @ X ) @ ( maps @ B @ A @ F4 @ Xs ) ) ) ).

% maps_simps(1)
thf(fact_196_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_197_concat__eq__append__conv,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys: list @ A,Zs: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys @ Zs ) )
      = ( ( ( Xss2
            = ( nil @ ( list @ A ) ) )
         => ( ( Ys
              = ( nil @ A ) )
            & ( Zs
              = ( nil @ A ) ) ) )
        & ( ( Xss2
           != ( nil @ ( list @ A ) ) )
         => ? [Xss1: list @ ( list @ A ),Xs3: list @ A,Xs4: list @ A,Xss22: list @ ( list @ A )] :
              ( ( Xss2
                = ( append @ ( list @ A ) @ Xss1 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs3 @ Xs4 ) @ Xss22 ) ) )
              & ( Ys
                = ( append @ A @ ( concat @ A @ Xss1 ) @ Xs3 ) )
              & ( Zs
                = ( append @ A @ Xs4 @ ( concat @ A @ Xss22 ) ) ) ) ) ) ) ).

% concat_eq_append_conv
thf(fact_198_concat__append,axiom,
    ! [A: $tType,Xs: list @ ( list @ A ),Ys: list @ ( list @ A )] :
      ( ( concat @ A @ ( append @ ( list @ A ) @ Xs @ Ys ) )
      = ( append @ A @ ( concat @ A @ Xs ) @ ( concat @ A @ Ys ) ) ) ).

% concat_append
thf(fact_199_concat_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( concat @ A @ ( nil @ ( list @ A ) ) )
      = ( nil @ A ) ) ).

% concat.simps(1)
thf(fact_200_concat_Osimps_I2_J,axiom,
    ! [A: $tType,X: list @ A,Xs: list @ ( list @ A )] :
      ( ( concat @ A @ ( cons @ ( list @ A ) @ X @ Xs ) )
      = ( append @ A @ X @ ( concat @ A @ Xs ) ) ) ).

% concat.simps(2)
thf(fact_201_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F4: B > ( list @ A )] :
      ( ( maps @ B @ A @ F4 @ ( nil @ B ) )
      = ( nil @ A ) ) ).

% maps_simps(2)
thf(fact_202_concat__eq__appendD,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys: list @ A,Zs: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys @ Zs ) )
     => ( ( Xss2
         != ( nil @ ( list @ A ) ) )
       => ? [Xss12: list @ ( list @ A ),Xs2: list @ A,Xs5: list @ A,Xss23: list @ ( list @ A )] :
            ( ( Xss2
              = ( append @ ( list @ A ) @ Xss12 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs2 @ Xs5 ) @ Xss23 ) ) )
            & ( Ys
              = ( append @ A @ ( concat @ A @ Xss12 ) @ Xs2 ) )
            & ( Zs
              = ( append @ A @ Xs5 @ ( concat @ A @ Xss23 ) ) ) ) ) ) ).

% concat_eq_appendD
thf(fact_203_nths__singleton,axiom,
    ! [A: $tType,A5: set @ nat,X: A] :
      ( ( ( member @ nat @ ( zero_zero @ nat ) @ A5 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A5 )
          = ( cons @ A @ X @ ( nil @ A ) ) ) )
      & ( ~ ( member @ nat @ ( zero_zero @ nat ) @ A5 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A5 )
          = ( nil @ A ) ) ) ) ).

% nths_singleton
thf(fact_204_lexord__append__left__rightI,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),U: list @ A,X: list @ A,Y: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ U @ ( cons @ A @ A2 @ X ) ) @ ( append @ A @ U @ ( cons @ A @ B2 @ Y ) ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_left_rightI
thf(fact_205_nths__nil,axiom,
    ! [A: $tType,A5: set @ nat] :
      ( ( nths @ A @ ( nil @ A ) @ A5 )
      = ( nil @ A ) ) ).

% nths_nil
thf(fact_206_lexord__cons__cons,axiom,
    ! [A: $tType,A2: A,X: list @ A,B2: A,Y: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ A2 @ X ) @ ( cons @ A @ B2 @ Y ) ) @ ( lexord @ A @ R ) )
      = ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
        | ( ( A2 = B2 )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ Y ) @ ( lexord @ A @ R ) ) ) ) ) ).

% lexord_cons_cons
thf(fact_207_lexord__Nil__left,axiom,
    ! [A: $tType,Y: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Y ) @ ( lexord @ A @ R ) )
      = ( ? [A6: A,X4: list @ A] :
            ( Y
            = ( cons @ A @ A6 @ X4 ) ) ) ) ).

% lexord_Nil_left
thf(fact_208_lexord__linear,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),X: list @ A,Y: list @ A] :
      ( ! [A4: A,B4: A] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B4 ) @ R )
          | ( A4 = B4 )
          | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B4 @ A4 ) @ R ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ Y ) @ ( lexord @ A @ R ) )
        | ( X = Y )
        | ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Y @ X ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_linear
thf(fact_209_lexord__irreflexive,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ R )
     => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Xs ) @ ( lexord @ A @ R ) ) ) ).

% lexord_irreflexive
thf(fact_210_lexord__Nil__right,axiom,
    ! [A: $tType,X: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ ( nil @ A ) ) @ ( lexord @ A @ R ) ) ).

% lexord_Nil_right
thf(fact_211_lexord__append__leftI,axiom,
    ! [A: $tType,U: list @ A,V: list @ A,R: set @ ( product_prod @ A @ A ),X: list @ A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ U @ V ) @ ( lexord @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ X @ U ) @ ( append @ A @ X @ V ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_leftI
thf(fact_212_lexord__append__leftD,axiom,
    ! [A: $tType,X: list @ A,U: list @ A,V: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ X @ U ) @ ( append @ A @ X @ V ) ) @ ( lexord @ A @ R ) )
     => ( ! [A4: A] :
            ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ A4 ) @ R )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ U @ V ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_append_leftD
thf(fact_213_lexord__append__rightI,axiom,
    ! [A: $tType,Y: list @ A,X: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ? [B6: A,Z3: list @ A] :
          ( Y
          = ( cons @ A @ B6 @ Z3 ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ ( append @ A @ X @ Y ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_rightI
thf(fact_214_lexord__same__pref__if__irrefl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( irrefl @ A @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Ys ) @ ( append @ A @ Xs @ Zs ) ) @ ( lexord @ A @ R ) )
        = ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys @ Zs ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_same_pref_if_irrefl
thf(fact_215_listrel_Ocases,axiom,
    ! [B: $tType,A: $tType,A1: list @ A,A22: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ A1 @ A22 ) @ ( listrel @ A @ B @ R ) )
     => ( ( ( A1
            = ( nil @ A ) )
         => ( A22
           != ( nil @ B ) ) )
       => ~ ! [X3: A,Y3: B,Xs2: list @ A] :
              ( ( A1
                = ( cons @ A @ X3 @ Xs2 ) )
             => ! [Ys3: list @ B] :
                  ( ( A22
                    = ( cons @ B @ Y3 @ Ys3 ) )
                 => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y3 ) @ R )
                   => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys3 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ) ) ).

% listrel.cases
thf(fact_216_listrel__rtrancl__refl,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] : ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Xs ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ).

% listrel_rtrancl_refl
thf(fact_217_lexord__irrefl,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ( irrefl @ A @ R2 )
     => ( irrefl @ ( list @ A ) @ ( lexord @ A @ R2 ) ) ) ).

% lexord_irrefl
thf(fact_218_listrel_ONil,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B )] : ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ ( nil @ B ) ) @ ( listrel @ A @ B @ R ) ) ).

% listrel.Nil
thf(fact_219_listrel__Nil1,axiom,
    ! [A: $tType,B: $tType,Xs: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ Xs ) @ ( listrel @ A @ B @ R ) )
     => ( Xs
        = ( nil @ B ) ) ) ).

% listrel_Nil1
thf(fact_220_listrel__Nil2,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ ( nil @ B ) ) @ ( listrel @ A @ B @ R ) )
     => ( Xs
        = ( nil @ A ) ) ) ).

% listrel_Nil2
thf(fact_221_listrel__rtrancl__trans,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A ),Zs: list @ A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys @ Zs ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Zs ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ) ) ).

% listrel_rtrancl_trans
thf(fact_222_listrel__Cons2,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Y: B,Ys: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ ( cons @ B @ Y @ Ys ) ) @ ( listrel @ A @ B @ R ) )
     => ~ ! [X3: A,Xs2: list @ A] :
            ( ( Xs
              = ( cons @ A @ X3 @ Xs2 ) )
           => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y ) @ R )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel_Cons2
thf(fact_223_listrel__Cons1,axiom,
    ! [B: $tType,A: $tType,Y: A,Ys: list @ A,Xs: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ Y @ Ys ) @ Xs ) @ ( listrel @ A @ B @ R ) )
     => ~ ! [Y3: B,Ys3: list @ B] :
            ( ( Xs
              = ( cons @ B @ Y3 @ Ys3 ) )
           => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Y @ Y3 ) @ R )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Ys @ Ys3 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel_Cons1
thf(fact_224_listrel_OCons,axiom,
    ! [B: $tType,A: $tType,X: A,Y: B,R: set @ ( product_prod @ A @ B ),Xs: list @ A,Ys: list @ B] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y ) @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ Ys ) @ ( listrel @ A @ B @ R ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ X @ Xs ) @ ( cons @ B @ Y @ Ys ) ) @ ( listrel @ A @ B @ R ) ) ) ) ).

% listrel.Cons
thf(fact_225_listrel__reflcl__if__listrel1,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% listrel_reflcl_if_listrel1
thf(fact_226_listrel__rtrancl__eq__rtrancl__listrel1,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) )
      = ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel_rtrancl_eq_rtrancl_listrel1
thf(fact_227_rtrancl__listrel1__if__listrel,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel @ A @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ).

% rtrancl_listrel1_if_listrel
thf(fact_228_listrel_Oinducts,axiom,
    ! [A: $tType,B: $tType,X1: list @ A,X2: list @ B,R: set @ ( product_prod @ A @ B ),P: ( list @ A ) > ( list @ B ) > $o] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ X1 @ X2 ) @ ( listrel @ A @ B @ R ) )
     => ( ( P @ ( nil @ A ) @ ( nil @ B ) )
       => ( ! [X3: A,Y3: B,Xs2: list @ A,Ys3: list @ B] :
              ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y3 ) @ R )
             => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys3 ) @ ( listrel @ A @ B @ R ) )
               => ( ( P @ Xs2 @ Ys3 )
                 => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y3 @ Ys3 ) ) ) ) )
         => ( P @ X1 @ X2 ) ) ) ) ).

% listrel.inducts
thf(fact_229_listrel_Osimps,axiom,
    ! [B: $tType,A: $tType,A1: list @ A,A22: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ A1 @ A22 ) @ ( listrel @ A @ B @ R ) )
      = ( ( ( A1
            = ( nil @ A ) )
          & ( A22
            = ( nil @ B ) ) )
        | ? [X4: A,Y6: B,Xs3: list @ A,Ys4: list @ B] :
            ( ( A1
              = ( cons @ A @ X4 @ Xs3 ) )
            & ( A22
              = ( cons @ B @ Y6 @ Ys4 ) )
            & ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X4 @ Y6 ) @ R )
            & ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs3 @ Ys4 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel.simps
thf(fact_230_irreflI,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ! [A4: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ A4 ) @ R2 )
     => ( irrefl @ A @ R2 ) ) ).

% irreflI
thf(fact_231_irrefl__def,axiom,
    ! [A: $tType] :
      ( ( irrefl @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [A6: A] :
            ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A6 @ A6 ) @ R3 ) ) ) ).

% irrefl_def
thf(fact_232_lenlex__append2,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A ),Us2: list @ A,Xs: list @ A,Ys: list @ A] :
      ( ( irrefl @ A @ R2 )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Us2 @ Xs ) @ ( append @ A @ Us2 @ Ys ) ) @ ( lenlex @ A @ R2 ) )
        = ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( lenlex @ A @ R2 ) ) ) ) ).

% lenlex_append2
thf(fact_233_irrefl__lex,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( irrefl @ A @ R )
     => ( irrefl @ ( list @ A ) @ ( lex @ A @ R ) ) ) ).

% irrefl_lex
thf(fact_234_Nil__lenlex__iff1,axiom,
    ! [A: $tType,Ns: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ns ) @ ( lenlex @ A @ R ) )
      = ( Ns
       != ( nil @ A ) ) ) ).

% Nil_lenlex_iff1
thf(fact_235_Nil__notin__lex,axiom,
    ! [A: $tType,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ys ) @ ( lex @ A @ R ) ) ).

% Nil_notin_lex
thf(fact_236_Nil2__notin__lex,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ ( nil @ A ) ) @ ( lex @ A @ R ) ) ).

% Nil2_notin_lex
thf(fact_237_lex__append__leftI,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys @ Zs ) @ ( lex @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Ys ) @ ( append @ A @ Xs @ Zs ) ) @ ( lex @ A @ R ) ) ) ).

% lex_append_leftI
thf(fact_238_lenlex__irreflexive,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ R )
     => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Xs ) @ ( lenlex @ A @ R ) ) ) ).

% lenlex_irreflexive
thf(fact_239_Nil__lenlex__iff2,axiom,
    ! [A: $tType,Ns: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ns @ ( nil @ A ) ) @ ( lenlex @ A @ R ) ) ).

% Nil_lenlex_iff2
thf(fact_240_lexl__not__refl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),X: list @ A] :
      ( ( irrefl @ A @ R )
     => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ X ) @ ( lex @ A @ R ) ) ) ).

% lexl_not_refl
thf(fact_241_lex__append__leftD,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Ys ) @ ( append @ A @ Xs @ Zs ) ) @ ( lex @ A @ R ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys @ Zs ) @ ( lex @ A @ R ) ) ) ) ).

% lex_append_leftD
thf(fact_242_lex__append__left__iff,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Ys ) @ ( append @ A @ Xs @ Zs ) ) @ ( lex @ A @ R ) )
        = ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys @ Zs ) @ ( lex @ A @ R ) ) ) ) ).

% lex_append_left_iff
thf(fact_243_Cons__in__lex,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Y: A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Ys ) ) @ ( lex @ A @ R ) )
      = ( ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
          & ( ( size_size @ ( list @ A ) @ Xs )
            = ( size_size @ ( list @ A ) @ Ys ) ) )
        | ( ( X = Y )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( lex @ A @ R ) ) ) ) ) ).

% Cons_in_lex
thf(fact_244_rotate1_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( rotate1 @ A @ ( cons @ A @ X @ Xs ) )
      = ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% rotate1.simps(2)
thf(fact_245_append__eq__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Us2: list @ A,Vs: list @ A] :
      ( ( ( ( size_size @ ( list @ A ) @ Xs )
          = ( size_size @ ( list @ A ) @ Ys ) )
        | ( ( size_size @ ( list @ A ) @ Us2 )
          = ( size_size @ ( list @ A ) @ Vs ) ) )
     => ( ( ( append @ A @ Xs @ Us2 )
          = ( append @ A @ Ys @ Vs ) )
        = ( ( Xs = Ys )
          & ( Us2 = Vs ) ) ) ) ).

% append_eq_append_conv
thf(fact_246_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rotate1 @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rotate1_is_Nil_conv
thf(fact_247_length__rotate1,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( size_size @ ( list @ A ) @ ( rotate1 @ A @ Xs ) )
      = ( size_size @ ( list @ A ) @ Xs ) ) ).

% length_rotate1
thf(fact_248_length__0__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( zero_zero @ nat ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% length_0_conv
thf(fact_249_listrel__eq__len,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Ys: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ Ys ) @ ( listrel @ A @ B @ R ) )
     => ( ( size_size @ ( list @ A ) @ Xs )
        = ( size_size @ ( list @ B ) @ Ys ) ) ) ).

% listrel_eq_len
thf(fact_250_length__code,axiom,
    ! [A: $tType] :
      ( ( size_size @ ( list @ A ) )
      = ( gen_length @ A @ ( zero_zero @ nat ) ) ) ).

% length_code
thf(fact_251_listrel1__eq__len,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys ) @ ( listrel1 @ A @ R ) )
     => ( ( size_size @ ( list @ A ) @ Xs )
        = ( size_size @ ( list @ A ) @ Ys ) ) ) ).

% listrel1_eq_len

% Type constructors (7)
thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 )
     => ( ord @ ( A7 > A8 ) ) ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_1,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Set_Oset___Orderings_Oord_2,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_3,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_4,axiom,
    ord @ $o ).

% Conjectures (5)
thf(conj_0,hypothesis,
    ( ( f @ ( zero_zero @ nat ) )
    = ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ b @ c ) @ cs ) @ s ) ) ).

thf(conj_1,hypothesis,
    ! [I3: nat] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( f @ I3 ) @ ( f @ ( suc @ I3 ) ) ) @ pHoare1053570893_exec1 ) ).

thf(conj_2,hypothesis,
    member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( f @ ( zero_zero @ nat ) ) @ ( f @ ( suc @ ( zero_zero @ nat ) ) ) ) @ pHoare1053570893_exec1 ).

thf(conj_3,hypothesis,
    ( ( f @ ( suc @ ( zero_zero @ nat ) ) )
    = ( product_Pair @ ( list @ com ) @ state @ a @ ba ) ) ).

thf(conj_4,conjecture,
    ( ~ ( b @ s )
    | ? [F5: nat > ( product_prod @ ( list @ com ) @ state )] :
        ( ( ( F5 @ ( zero_zero @ nat ) )
          = ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ c @ ( cons @ com @ ( while @ b @ c ) @ cs ) ) @ s ) )
        & ! [I2: nat] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( F5 @ I2 ) @ ( F5 @ ( suc @ I2 ) ) ) @ pHoare1053570893_exec1 ) ) ) ).

%------------------------------------------------------------------------------
